/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_FUTURE_IMPL_H
#define _SCE_FUTURE_IMPL_H
#include "ps3_condition_variable.h"


#include <stdlib.h>
namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {

	/// @brief
	/// A future provides an asynchronous reference to a piece of data. It represents
	/// a piece of data that will be finalised at some point in the future. The object
	/// contains the synchronisation required for 1 thread to wait on the result of 1 other
	/// thread completing the operation.
	///
	///	The future will represent a piece of data to be written to asynchronously by another thread.
	/// The future has the relevant synchronisation so that the thread that requests the data can either,
	/// wait on it being provided or to query the future for its completion at periodic points in code. This
	/// provides flexibility as to when the data synchronisation is actually performed.
	/// The FutureImpl class contains the main synchronisation code required
	/// for the PS3 version of the future object. 
	///
	/// @note the full implementation details and examples are in the template class future<T> 


	class FutureImpl //: public AbstractFuture{
	{
	public:
		/// @brief
		/// Returns whether a result is ready for this Future instance.
		///
		///	Returns whether a result is ready for this Future instance.
		/// @return Returns true if result is ready, otherwise false.
		bool	hasResult() const;
		/// @brief
		/// Returns whether a result is ready for this Future instance.
		///
		///	Returns whether a result is ready for this Future instance.
		/// @return Returns true if the request errored, otherwise false
		bool	hasError() const;
		/// @brief
		/// Returns the error code of this Future.
		///
		/// Used to fetch the error code after having checked for whether one has happened.
		/// @return Returns the current error code status, if no error it will return 0 / SCE_TOOLKIT_NP_SUCCESS
		/// @retval 1 Indicates that a result is present and ready.
		int32_t	getError() const;
	
		//void	wait() const;
		/// @brief
		/// This method waits on the result being set by an asynchronous thread.
		///
		/// This method will wait until the result of the future has been set in another thread or
		/// until the timeout in microseconds is reached.
		/// @param timeout This parameter sets the timeout of the wait method. If 0 is passed then the method
		///					return immediately. 
		/// @note Due to this implementation of futures not being tightly bound to the thread objects that are
		///			responsible for them we have not allowed indefinite waits as this could cause deadlocks. If the
		///			futures were more tightly coupled and the threads could guarantee that all futures were properly 
		///			terminated then this would be less of an issue.			
		void	waitFor(unsigned int timeout) const;

		/// @brief
		/// Sets the error code of this object.
		///
		/// Sets the error code of this object and signals any waiting threads.
		/// @param err The error code that is being set.
		//void	setError(int32_t err);


		//void	setResultTrue();

		/// @brief
		/// Reset the future object.
		///
		/// This resets the object to the state it had at initialisation.
		/// Don't use this while a thread is waiting on it.
		bool reset();

		void setBusy();

		bool isBusy();
	protected:
		/// @brief protected default constructor.
		///
		/// protected default constructor to prevent instantiation of the Abstract class.
		/// Initialises the wrapped semaphore.
		FutureImpl();
		/// @brief virtual destructor
		///
		/// destroys the wrapped semaphore.
		virtual ~FutureImpl();
		/// @brief 
		/// resultSet() triggers the necessary synchronisation code once the result is set.
		/// 
		/// resultSet() triggers the necessary synchronisation code once the result is set.
		//void	resultSet();

		ConditionVariableImpl		m_sync;		 /// The semaphore used to protect the data.
		volatile mutable int32_t	m_errorCode; /// The error code if an error has occurred.
	};


			}//end Utilities
		}//end NP
	}//end Toolkit
}//end sce
#endif
